% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg.R
\name{ggrisktable}
\alias{ggrisktable}
\title{Create a ggplot2 table showing the number at risk}
\usage{
ggrisktable(
  fit = NULL,
  times = NULL,
  text.color = "black",
  strata.order = NULL
)
}
\arguments{
\item{fit}{Required. survival::survfit() object.}

\item{times}{Required. Numeric. One or more time points to calculate
the number at risk for.}

\item{text.color}{Optional. Character. Color of text within table. Defaults
to 'black'.}

\item{strata.order}{Optional. Character. Ordered names of strata factor
levels.}
}
\value{
An unformatted ggplot2 table showing the number at risk.
}
\description{
A simple wrapper function which calculates the
numbers at risk for a survival model and a given set of time points then
creates a ggplot2 table with them.
}
\examples{
library(survival)

fit <- survfit(Surv(time, status) ~ trt, data = diabetic)

ggrisktable(
   fit = fit,
   times = c(0, 10, 20, 30, 40, 50),
   strata.order = c('0', '1')
) + theme_risk_black()
}
