% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{connect_origin}
\alias{connect_origin}
\title{Connect tidy'd survival::survfit data to the origin of a plot}
\usage{
connect_origin(data)
}
\arguments{
\item{data}{Required. tibble::tibble() object. survival::survfit data that has been
tidy'd with broom::tidy().}
}
\value{
A tibble containing the original data with appended points that connect the
curve with to the plot origin.
}
\description{
Occasionally when tidy'd survfit data is graphed in ggplot2::geom_step(),
the KM curve will not connect with the origin of the plot. This tool appends data
connecting the lines to the origin.
}
\note{
Adapted from the survminer package created by Alboukadel Kassambara.
}
\examples{
library(survival)
library(broom) # tidy() model data

# Data with group names specified
data_diabetic <- diabetic
data_diabetic$trt <- as.factor(data_diabetic$trt)
levels(data_diabetic$trt) <- c('None', 'Laser')

# Survival Model
fit <- survfit(Surv(time, status) ~ trt, data = data_diabetic)
fit_data <- tidy(fit)

connect_origin(fit_data)
}
