% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_row.R
\name{build_row.data.frame}
\alias{build_row.data.frame}
\title{Summarize a data.frame or tibble}
\usage{
\method{build_row}{data.frame}(
  x,
  y,
  label = "n(\%)",
  show.missing = FALSE,
  show.test = FALSE,
  percent.sign = TRUE,
  digits = 1,
  ...
)
}
\arguments{
\item{x}{An data.frame object. Data to summarize. Must be the same length as
\code{y} (if specified).}

\item{y}{A factor or logical. Optional. Data to stratify \code{x} by.}

\item{label}{A character. Optional. The name of the summarized variable.}

\item{show.missing}{A logical. Optional. Append an empty missing data column.}

\item{show.test}{A logical. Optional. Append empty test and statistic columns.}

\item{percent.sign}{A logical. Optional. Paste a percentage symbol with each
frequency.}

\item{digits}{An integer. Optional. Number of digits to round to.}

\item{...}{Miscellaneous options.}
}
\value{
An object of class \code{tbl_df} (tibble) summarizing the provided
data.
}
\description{
Summarize a data.frame (row counts). Optional stratification
using a factor or logical with the same size as the tibble.
}
\examples{
# Create a "count" row from a data.frame for a factor
build_row(x = datasets::mtcars, y = as.factor(datasets::mtcars$cyl))
}
