% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fns.R
\name{get_curve}
\alias{get_curve}
\title{Compute the model for a given subject's data and best-fit parameters}
\usage{
get_curve(data, best_param, param_names, whichcurve = get_biphasic)
}
\arguments{
\item{data}{data frame with columns for the subject's identifier ('id') and timing of sampling ('time')}

\item{best_param}{named numeric vector of best fit parameters obtained from fitting the biphasic or single phase model to the subjects data}

\item{param_names}{character vector containing the names of the parameters in 'best_param'}

\item{whichcurve}{character indicating which model function should be used. Use 'get_biphasic' for the biphasic model, or 'get_singlephase' for the single phase model. Defaults to 'get_biphasic'.}
}
\value{
data frame with columns for the sampling times ('time'), fitted viral load predictions ('fit'), and the corresponding subject identifier ('id')
}
\description{
This function calculates the biphasic or single phase model given a subject's data and best-fit parameters
}
\examples{

nobs <- 7
example_param <- c(A = 10000, delta = 0.03, B = 1000, gamma = 0.68)

vldata <- get_biphasic(params = example_param, timevec = seq(5, 100, length.out = nobs))

subjectdata <- data.frame(id = 123, time = seq(5, 100, length.out = nobs),
                          vl = 10^ (log10(vldata) + rnorm(nobs, 0, 0.2)))

get_curve(data = subjectdata, best_param = example_param, param_names = names(example_param))
}
