% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_processing.R
\name{plot_data}
\alias{plot_data}
\title{Plot data}
\usage{
plot_data(data, textsize = 9, pointsize = 1, linesize = 0.5,
  facet_col = NULL, detection_threshold = 20)
}
\arguments{
\item{data}{data frame of raw, filtered, or simulated data. Must include the following columns: 'id' - stating the unique identifier for each subject; 'vl' - numeric vector stating the viral load measurements for each subject; 'time'- numeric vector stating the time at which each measurement was taken.}

\item{textsize}{numeric value for base text size in ggplot. Default is 9.}

\item{pointsize}{numeric value for point size in ggplot. Default is 1.}

\item{linesize}{numeric value for line width in ggplot. Default is 0.5.}

\item{facet_col}{numeric value for number of columns to use when faceting subject panels. Defaults to NULL (i.e. ggplot default).}

\item{detection_threshold}{numeric value indicating the detection threshold of the assay used to measure viral load. Default value is 20.}
}
\description{
This function plots raw, filtered, or simulated data.
}
\examples{

set.seed(1234567)

simulated_data <- simulate_data(nsubjects = 20)

plot_data(simulated_data)

}
