% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/course.R
\name{use_course}
\alias{use_course}
\title{Download course materials}
\usage{
use_course(url, destdir = NULL)
}
\arguments{
\item{url}{Link to a ZIP file containing the materials, possibly behind a
shortlink. Function developed with DropBox and GitHub in mind, but should
work for ZIP files generally. If no "http" prefix is found, "https://" is
prepended. See \link{use_course_details} for more.}

\item{destdir}{The new folder is stored here. Defaults to user's Desktop.}
}
\value{
Path to the new directory holding the course materials, invisibly.
}
\description{
Special-purpose function to download a folder of course materials. The only
demand on the user is to confirm or specify where the new folder should be
stored. Workflow:
\itemize{
\item User executes something like: \code{use_course("bit.ly/xxx-yyy-zzz")}.
\item User is asked to notice and confirm the location of the new folder. Specify
\code{destdir} to skip this.
\item User is asked if they'd like to delete the ZIP file.
\item If new folder contains an \code{.Rproj} file, it is opened. Otherwise, the
folder is opened in the file manager, e.g. Finder or File Explorer.
}
}
\details{
If \code{url} has no "http" prefix, "https://" is prepended, allowing for even
less typing by the user. Most URL shorteners give HTTPS links and,
anecdotally, we note this appears to work with \href{https://bitly.com/}{bit.ly}
links, even though they are nominally HTTP.
}
\examples{
\dontrun{
## bit.ly shortlink example
## should work with and without http prefix
use_course("bit.ly/usethis-shortlink-example")
use_course("http://bit.ly/usethis-shortlink-example")

## demo with a small CRAN package available in various places

## from CRAN
use_course("https://cran.r-project.org/bin/windows/contrib/3.4/rematch2_2.0.1.zip")

## from GitHub, 2 ways
use_course("https://github.com/r-lib/rematch2/archive/master.zip")
use_course("https://api.github.com/repos/r-lib/rematch2/zipball/master")
}
}
\seealso{
Other download functions: \code{\link{use_course_details}}
}
\concept{download functions}
