% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{post_prob}
\alias{post_prob}
\title{Variational posterior probability of having \code{dosage} A alleles
when the ploidy is \code{ploidy}, the allele frequency is
\code{alpha}, the individual-specific overdispersion parameter is
\code{rho}, the variational mean is \code{mu}, and the variational
variance is \code{sigma2}.}
\usage{
post_prob(dosage, ploidy, mu, sigma2, alpha, rho)
}
\arguments{
\item{dosage}{The number of A alleles.}

\item{ploidy}{The ploidy of the individual.}

\item{mu}{The variational mean.}

\item{sigma2}{The variational variance (not standard deviation).}

\item{alpha}{The allele frequency.}

\item{rho}{The individual's overdispersion parameter.}
}
\value{
The posterior probability of having \code{dosage} A alleles.
}
\description{
Variational posterior probability of having \code{dosage} A alleles
when the ploidy is \code{ploidy}, the allele frequency is
\code{alpha}, the individual-specific overdispersion parameter is
\code{rho}, the variational mean is \code{mu}, and the variational
variance is \code{sigma2}.
}
\author{
David
}
\keyword{internal}
