% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhat-terms.R
\name{rhat_terms}
\alias{rhat_terms}
\title{R-hat Terms}
\usage{
rhat_terms(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A list of uniquely named numeric objects with values >= 1
indicating the rhat value for each term.
}
\description{
Calculates an R-hat (potential scale reduction factor) value for each term.
}
\details{
By default the uncorrected, unfolded, univariate,
split R-hat value.
}
\examples{
rhat_terms.foobar <- function(x, ...) {
  NotYetImplemented()
  # replace with code to get rhat for each term of an object of
  # class 'foobar'
}
}
\references{
Gelman, A., and Rubin, D.B. 1992.
Inference from Iterative Simulation Using Multiple Sequences.
Statistical Science 7(4): 457–472.
}
\seealso{
Other convergence: 
\code{\link{converged_pars}()},
\code{\link{converged_terms}()},
\code{\link{converged}()},
\code{\link{esr_pars}()},
\code{\link{esr_terms}()},
\code{\link{esr}()},
\code{\link{rhat_pars}()},
\code{\link{rhat}()}
}
\concept{convergence}
