% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr-kum.R
\name{kum}
\alias{kum}
\alias{dkum}
\alias{pkum}
\alias{qkum}
\alias{rkum}
\title{The Kumaraswamy distribution}
\usage{
dkum(x, mu, theta, tau = 0.5, log = FALSE)

pkum(q, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

qkum(p, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

rkum(n, mu, theta, tau = 0.5)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{mu}{location parameter indicating the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.}

\item{theta}{nonnegative shape parameter.}

\item{tau}{the parameter to specify which quantile is to used.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq{x})} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dkum} gives the density, \code{pkum} gives the distribution function,
\code{qkum} gives the quantile function and \code{rkum} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function and random number generation for the Kumaraswamy distribution  reparametrized in terms of the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.
}
\details{
Probability density function
\deqn{f(y\mid \alpha ,\theta )=\alpha \theta y^{\theta -1}(1-y^{\theta })^{\alpha-1}}

Cumulative distribution function
\deqn{F(y\mid \alpha ,\theta )=1-\left( 1-y^{\theta }\right) ^{\alpha }}

Quantile function
\deqn{Q(\tau \mid \alpha ,\theta )=\left[ 1-\left( 1-\tau \right) ^{\frac{1}{\alpha }}\right] ^{\frac{1}{\theta }}}

Reparameterization
\deqn{\alpha=g^{-1}(\mu )=\frac{\log (1-\tau )}{\log (1-\mu ^{\theta })}}
}
\examples{
set.seed(123)
x <- rkum(n = 1000, mu = 0.5, theta = 1.5, tau = 0.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by =  0.01)
hist(x, prob = TRUE, main = 'Kumaraswamy')
lines(S, dkum(x = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
plot(ecdf(x))
lines(S, pkum(q = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
plot(quantile(x, probs = S), type = "l")
lines(qkum(p = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
}
\references{
Kumaraswamy, P., (1980). A generalized probability density function for double-bounded random processes. \emph{Journal of Hydrology}, \bold{46}(1), 79--88.

Jones, M. C., (2009). Kumaraswamy's distribution: A beta-type distribution with some tractability advantages. \emph{Statistical Methodology}, \bold{6}(1), 70-81.
}
\author{
Josmar Mazucheli

André F. B. Menezes
}
