% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt.R
\name{unitizer_prompt}
\alias{unitizer_prompt}
\alias{navigate_prompt}
\alias{review_prompt}
\alias{simple_prompt}
\alias{exit_fun}
\alias{read_line}
\alias{read_line_set_vals}
\alias{interactive_mode}
\title{Interactively Retrieve User Input}
\usage{
unitizer_prompt(text, browse.env = baseenv(), help = character(),
  help.opts = character(), valid.opts, hist.con = NULL,
  exit.condition = function(exp, env) FALSE, global, ...)

navigate_prompt(x, curr.id, text, browse.env1 = globalenv(),
  browse.env2 = globalenv(), help = character(),
  help.opts = character(), valid.opts)

review_prompt(x, nav.env)

simple_prompt(message, values = c("Y", "N"), prompt = "unitizer> ",
  attempts = 5L, case.sensitive = FALSE)

exit_fun(y, env, valid.vals)

read_line(prompt = "")

read_line_set_vals(vals)

interactive_mode()
}
\arguments{
\item{text}{the prompt text to display}

\item{browse.env}{the environment to evaluate user expressions in; typically
this will contain interesting objects (use \code{ls()} to review)}

\item{help}{a character vector with help suggestions: the first value in the
vector is \code{\link{word_cat}} output, the rest normal \code{cat}}

\item{help.opts}{a character vector of help options}

\item{valid.opts}{the special letters user can type to get a special action,
typically a character vector where the names are one letter (though they
don't actually have to be) and are looked for as user typed input; note that
the quit and help options will always be appended to this}

\item{hist.con}{connection to save history to}

\item{exit.condition}{function used to evaluate whether user input should
cause the prompt loop to exit; this function should accept two parameters:
\itemize{
  \item expression typed in by the user
  \item environment the environment user expressions get evaluated in
}
The function can then decide to exit or not based on either the literal
expression or evaluate the expression and decide based on the result.  This
is implemented this way because \code{eval_user_exp} will print to screen
which may not be desirable.  Function should return a value which will then
be returned by \code{unitizer_prompt}, unless this value is \code{FALSE}
in which case \code{unitizer_prompt} will continue with normal evaluation.}

\item{global}{unitizerGlobal or NULL, if the global state tracking object;
will be used to record state after evaluating user expressions}

\item{...}{additional arguments for \code{exit.condition}}

\item{x}{a unitizerBrowse object}

\item{curr.id}{which id we are currently browsing}

\item{browse.env1}{environment to have user review tests, run commands, etc}

\item{browse.env2}{navigation environment}

\item{nav.env}{an environment}

\item{message}{character ask the user a question}

\item{values}{character valid responses}

\item{prompt}{see \code{\link{readline}}}

\item{attempts}{how many times to try before erroring}

\item{case.sensitive}{whether to care about case sensitivity when matching
user input}
}
\value{
\itemize{
  \item \code{unitizer_prompt}: mixed allowable user input
  \item \code{navigate_prompt}: a \code{unitizerBrowse} object, or allowable
    user input
  \item \code{review_prompt}: a \code{unitizerBrowse} object, or "Q" if the
    user chose to quit
  \item \code{simple_prompt}: one of \code{values} as selected by user
}
}
\description{
Different functions used in different contexts to capture user input.
\code{unitizer_prompt}, \code{navigate_prompt}, and \code{review_prompt} are
more advanced and allow evaluation of arbitrary expressions, in addition to
searching for specific commands such as "Y", "N", etc. \code{simple_prompt}
only matches along specified values.
}
\details{
The set-up is intended to replicate something similar to what happens when
code hits a \code{browse()} statement.  User expressions are evaluated
and output to screen, and special expressions as described above cause the
evaluation loop to terminate.

\code{navigate_prompt} is just a wrapper around \code{unitizer_prompt} that
provides the special shortcuts to navigate to other tests in the
\code{unitizer}.

\code{review_prompt} is also a wrapper, but used only when at the menu that
presents available test items to navigate to.

\code{simple_prompt} simpler prompting function used to allow user to select
from pre-specified values.

\code{exit_fun} is used as a generic function to pass to the
\code{exit.condition} argument of \code{unitizer_prompt}.

\code{read_line} and \code{read_line_set_vals} are utility functions that
are used to implement a version of \code{\link{readline}} that can be
automated for testing.

\code{interactive_mode} returns interactive status, accounting for whether
we are in faux-interactive mode as set by \code{read_line_set_vals}
}
\seealso{
browse_unitizer_items
}
\keyword{internal}
