% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_regensburg_1}
\alias{uni_regensburg_1}
\title{General colors of the University of Regensburg}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on 
\url{https://www.uni-regensburg.de/verwaltung/corporate-design/index.html}.
}
\usage{
uni_regensburg_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_regensburg_1} provides the general (administrative and service-oriented) colors 
of the \href{https://www.uni-regensburg.de/}{University of Regensburg}, Germany.
}
\details{
Named colors of \code{uni_regensburg_1} correspond to the following UR services:

\enumerate{
\item \code{neutralgrau}: Main color (UR-Hausfarbe, Logo)  
\item \code{blaugrau}: Leitung, Organe und Verwaltung (LOV, Ausnahme: Referate I/3, I/4, I/5, I/6)
\item \code{schwarzrot}: Chancengleichheit und Familie (Familien-Service, Frauenbeauftragte, Frauenfoerderung, Gleichstellung)
\item \code{schilfgruen}: Service-Einrichtungen der Verwaltung für Studierende (Akademisches Auslandsamt, Studentenkanzlei, Zentrales Pruefungssekretariat, Zentrale Studienberatung, Senatsbeauftragter für Behinderte und chronisch Kranke) 
\item \code{dianthusrot}: Universitaetsbibliothek (UB)
\item \code{saphirblau}: Rechenzentrum (RZ)
\item \code{farngruen}: Zentrum fuer Weiterbildung
\item \code{rotbraun}: Zentrum fuer Sprache und Kommunikation (ZSK)
\item \code{perlviolett}: Europaeum (Ost-West-Zentrum)
\item \code{violettrot}: Zentrum fuer Hochschul- und Wissenschaftsdidaktik (ZHW)
\item \code{gruenbraun}: Regensburger Universitätszentrum fuer Lehrerbildung (RUL)
\item \code{wasserblau}: Sportzentrum (SZ)
}

When coloring large areas, named colors may be used in shades of 70%.
}
\examples{
uni_regensburg_1
seecol(uni_regensburg_1, main = "General colors of the University of Regensburg")
demopal(uni_regensburg_1, alpha = .70, type = 2, 
        main = "General colors of Regensburg University")

}
\seealso{
\code{\link{uni_regensburg_2}} and \code{\link{uni_regensburg_3}} for the faculty colors of the University of Regensburg;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2022-11-25.
}
\concept{contributed color palettes}
\keyword{datasets}
