% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{rpi_pal_1}
\alias{rpi_pal_1}
\title{Primary colors of RPI}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\url{https://scer.rpi.edu/brand-in-action/colors}.
}
\usage{
rpi_pal_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{rpi_pal_1} provides the primary colors of the 
\href{https://www.rpi.edu/}{Rensselaer Polytechnic Institute} (RPI), Troy, NY.
}
\details{
These colors represent the core colors and should provide the foundation for the palette used. 
Their usage should dominate the use of the secondary colors of \code{\link{rpi_pal_2}} 
and their tint variants of \code{\link{rpi_pal_3}}.
}
\examples{
rpi_pal_1
seecol(rpi_pal_1, main = "The primary colors of RPI")  # view color palette
demopal(rpi_pal_1, type = 3, main = "Primary colors of RPI")

}
\seealso{
\code{\link{rpi_pal_2}} for secondary colors of RPI; 
\code{\link{rpi_pal_3}} for tint colors of RPI; 
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2022-12-01.
}
\concept{contributed color palettes}
\keyword{datasets}
