% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_asset.R
\name{add_default_player}
\alias{add_default_player}
\alias{add_default_tree}
\title{Add assets to a Unity scene}
\usage{
add_default_player(
  script,
  controller = c("Player", "FootstepsPlayer", "JetpackPlayer", "Third Person"),
  asset_directory = NULL,
  lazy = TRUE,
  method_name = NULL,
  destination_scene = NULL,
  x_position = 0,
  y_position = 0,
  z_position = 0,
  x_scale = 1,
  y_scale = 1,
  z_scale = 1,
  x_rotation = 0,
  y_rotation = 0,
  z_rotation = 0,
  exec = TRUE
)

add_default_tree(
  script,
  tree,
  asset_directory = NULL,
  lazy = TRUE,
  method_name = NULL,
  destination_scene = NULL,
  x_position = 0,
  y_position = 0,
  z_position = 0,
  x_scale = 1,
  y_scale = 1,
  z_scale = 1,
  x_rotation = 0,
  y_rotation = 0,
  z_rotation = 0,
  exec = TRUE
)
}
\arguments{
\item{script}{A \code{unifir_script} object, created by \link{make_script} or returned
by an \verb{add_prop_*} function.}

\item{controller}{Which controller to use. "Player", the default,
is a simple first-person controller. "FootstepsPlayer" adds footsteps
to this controller, while "JetpackPlayer" adds a "jetpack" with limited
fuel. ""Third Person" lets you control a small cylinder in third person.}

\item{asset_directory}{A file path to the directory containing the asset,
or alternatively, to which the default assets should be saved.
Defaults to \code{tools::R_user_dir("unifir")}.}

\item{lazy}{Boolean: if TRUE, unifir will attempt to only copy the files
once per run of a script; if FALSE, unifir will copy the files as many times
as requested, overwriting pre-existing files each time.}

\item{method_name}{The internal name to use for the C# method created. Will
be randomly generated if not set.}

\item{destination_scene}{Optionally, the scene to instantiate the prefabs
in. Ignored if NULL, the default.}

\item{x_position, y_position, z_position}{The position of the GameObject in
world space.}

\item{x_scale, y_scale, z_scale}{The scale of the GameObject (relative to its
parent object).}

\item{x_rotation, y_rotation, z_rotation}{The rotation of the GameObject to
create, as Euler angles.}

\item{exec}{Logical: Should the C# method be included in the set executed by
MainFunc?}

\item{tree}{Which tree to use. There are currently 12 generic tree objects
available, named "tree_1" through "tree_12". The number of a tree (1-12)
can be specified instead of the full name.}
}
\value{
The \code{unifir_script} object passed to \code{script}, with props for adding
assets appended.
}
\description{
These functions add assets available at
https://github.com/mikemahoney218/unity_assets/
to a Unity scene.
}
\details{
In effect, these functions provide a thin wrapper across \link{instantiate_prefab}
and \link{import_asset}. By providing the directory an asset is stored in, and the
path to the prefab file once that directory has been copied into Unity,
these files will add prefabs to specified locations throughout the scene.
This function will also download the necessary assets
and handles specifying file paths.

\link{add_default_player} adds "player" controllers to a Unity scene.
\link{add_default_tree} adds tree GameObjects.
}
\examples{
if (interactive()) {
  # First, create a script object.
  # CRAN doesn't have Unity installed, so pass
  # a waiver object to skip the Unity-lookup stage:
  script <- make_script("example_script", unity = waiver())

  # Now add props:
  script <- add_default_player(script)
  script <- add_default_tree(script, 1)
  script <- save_scene(script)
}

# Lastly, execute the script via the `action` function

}
\seealso{
Other props: 
\code{\link{add_light}()},
\code{\link{add_prop}()},
\code{\link{add_texture}()},
\code{\link{create_terrain}()},
\code{\link{import_asset}()},
\code{\link{instantiate_prefab}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()}

Other utilities: 
\code{\link{add_prop}()},
\code{\link{create_unity_project}()},
\code{\link{find_unity}()},
\code{\link{get_asset}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()},
\code{\link{waiver}()}
}
\concept{props}
\concept{utilities}
