% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Queens_University.R
\docType{data}
\name{queensu_1}
\alias{queensu_1}
\title{Primary colours of Queen's University, Canada}
\format{
An object of class \code{character} of length 3.
}
\source{
Colour definitions are based on the
\href{https://www.queensu.ca/brand-central/visual-identity/colours}{Visual Identity}.
}
\usage{
queensu_1
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{queensu_1} provides the three primary colours 
of \href{https://www.queensu.ca/}{Queen's University}, Canada.
}
\details{
Queen’s University is widely recognized for its unique Tricolour palette of blue, gold, and red. 
These three colours are the essence of the Queen’s brand and are designated as the primary colours.
 
Tricolour must be incorporated into all applications in a mindful way 
that allows the message and imagery to be the focus.

The three primary colours are 
\code{"queens_blue"} (defined as PMS 295, CMYK 100/63/0/67, RGB 0/36/82, HEX #002452),
\code{"queens_gold"} (defined as PMS 124, CMYK 0/29/100/1, RGB 250/189/15, HEX #fabd0f), and
\code{"queens_red"} (defined as PMS 187, CMYK 0/100/74/26, RGB 185/14/49, HEX #b90e31).

\code{queensu_1} uses the HEX colour definition. 
PMS and CMYK colours differ from RGB and HEX definition.
}
\examples{
queensu_1
unikn::seecol(queensu_1, main = "Primary colours of Queen's University") # view colour palette

}
\seealso{
\code{\link{queensu_2}} for the secondary colours of Queen's University;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-28.
}
\concept{Canadian university color palettes}
\keyword{datasets}
