% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Otago.R
\docType{data}
\name{otago}
\alias{otago}
\title{Colours of the University of Otago, NZ}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the \href{https://www.otago.ac.nz}{UOtago}'s 
\href{https://www.otago.ac.nz/marketing-services/resources/university-of-otago-brand-guide}{Brand guide}.
}
\usage{
otago
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{otago} provides the four screen colours
of the \href{https://www.otago.ac.nz}{University of Otago}, New Zealand.
}
\details{
The four screen colours are 
\code{Otago blue} defined as \code{R: 0, G: 80, B: 143} or \code{HEX "#00508F"}, 
\code{Otago gold} defined as \code{R: 250, G: 198, B: 0} or \code{HEX "#f9c013"}, 
\code{Otago red} defined as \code{R: 198, G: 53, B: 29} or \code{HEX "#ce2227"}, and 
\code{Otago black} defined as \code{R: 0, G: 0, B: 0} or \code{HEX "#1b1c20"}. 

\code{otago} uses the HEX color definitions.
}
\examples{
otago
unikn::seecol(otago, main = "Colours of the University of Otago, NZ")  # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other New Zealand university color palettes: 
\code{\link{auckland_1}},
\code{\link{auckland_2}},
\code{\link{waikato}}
}
\author{
\strong{unicol}, 2023-09-08.
}
\concept{New Zealand university color palettes}
\keyword{datasets}
