% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dartmouth.R
\docType{data}
\name{dartmouth_2}
\alias{dartmouth_2}
\title{Secondary colors of Dartmouth College, USA}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on 
\href{https://communications.dartmouth.edu/visual-identity/design-elements/color-palette}{Dartmouth's visual identity guide}.
}
\usage{
dartmouth_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{dartmouth_2} provides the eight secondary colors
of the \href{https://home.dartmouth.edu}{Dartmouth College}, USA.
}
\details{
The 8 secondary colors are 
\code{"forest_green"} (defined as HEX #12312b),
\code{"rich_forest_green"} (defined as HEX #0D1E1C),
\code{"snow_white"} (defined as HEX #ffffff),
\code{"midnight_black"} (defined as HEX #000000)
\code{"web_gray_1"} (defined as HEX #f7f7f7)
\code{"web_gray_2"} (defined as HEX #e2e2e2)
\code{"web_gray_3"} (defined as HEX #707070)
\code{"granite_gray"} (defined as HEX #424141)

\code{dartmouth_2} uses the HEX color definitions.
}
\examples{
dartmouth_2
unikn::seecol(dartmouth_2, main = "Dartmouth College 2") # view color palette

}
\seealso{
\code{\link{dartmouth_1}} for the primary color of Dartmouth College;
\code{\link{dartmouth_3}} for the tertiary colors of Dartmouth College; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{trinity_2}},
\code{\link{uci_2}},
\code{\link{uflorida_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2320-07-13.
}
\concept{university color palettes.}
\keyword{datasets}
