% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_mf.R
\name{annotate_mf}
\alias{annotate_mf}
\title{Annotate meaningful formatting}
\usage{
annotate_mf(xlfilepath, orig, new)
}
\arguments{
\item{xlfilepath}{Path to a single-sheet spreadsheet file (xls or xlsx).}

\item{orig}{Variable to annotate formatting in.}

\item{new}{Name of new variable with cell formatting pasted as a string.}
}
\value{
A tibble with a new column with meaningful formatting embedded as
text.
}
\description{
Turns cell formatting into annotations for values in the target row.
}
\details{
At this point, seven popular approaches for meaningful
formatting (bold, colored text, italic, strikethrough, underline, double underline, and cell highlighting) are hardcoded in
the function. \code{sheets}, \code{skip}, and \code{range} arguments for spreadsheet input
are not supported. The hex8 code of the fill color used for text color and cell
highlighting is also appended in the output. Ensure the data in the
spreadsheet are rectangular before running.
}
\examples{
example_spreadsheet <- system.file("extdata/dog_test.xlsx", package = "unheadr")
annotate_mf(example_spreadsheet, orig = Task, new = Task_annotated)
}
