% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pclm_2D.R
\name{residuals.pclm2D}
\alias{residuals.pclm2D}
\title{Extract PCLM-2D Deviance Residuals}
\usage{
\method{residuals}{pclm2D}(object, ...)
}
\arguments{
\item{object}{an object for which the extraction of model residuals is
    meaningful.}

\item{...}{other arguments.}
}
\value{
Residuals extracted from the object \code{object}.
}
\description{
Extract PCLM-2D Deviance Residuals
}
\examples{

Dx <- ungroup.data$Dx
Ex <- ungroup.data$Ex

# Aggregate data to ungroup it in the example below
x      <- c(0, 1, seq(5, 85, by = 5))
nlast  <- 26
n      <- c(diff(x), nlast)
group  <- rep(x, n)
y      <- aggregate(Dx, by = list(group), FUN = "sum")[, -1]

# Example
P1 <- pclm2D(x, y, nlast)

residuals(P1)
}
