% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{fin_percent_off}
\alias{fin_percent_off}
\title{Compute the percent change needed to return to the original value after percent off (or on).}
\usage{
fin_percent_off(percent, value = 100, digits = 2)
}
\arguments{
\item{percent}{Change in percent (e.g. 0.1 = 10\%\%)}

\item{value}{Principal}

\item{digits}{(rounding)}
}
\value{
\itemize{
\item new value and change required to return to baseline.
}
}
\description{
Determine the percent change needed to "undo" an initial percent change.
}
\details{
None.
If an amount of $100 has 20\% added, what percent do we need to drop it by to return to the original value?
}
\examples{
#
# Percent needed to return to original value after 10\% off
fin_percent_off(-.1)
fin_percent_off(-.1, digits=3)
#
# Percent needed to return to original value after 10\% on
fin_percent_off(.1)
# Percent needed to return to original value after 50\% off 34.50
fin_percent_off(-.5, value = 34.5)
}
\seealso{
\itemize{
\item \code{\link[=fin_compound_interest]{fin_compound_interest()}}
}

Other Miscellaneous Functions: 
\code{\link{deg2rad}()},
\code{\link{fin_compound_interest}()},
\code{\link{rad2deg}()}
}
\concept{Miscellaneous Functions}
