% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umxFactor}
\alias{umxFactor}
\alias{umx_factor}
\title{umxFactor}
\usage{
umxFactor(
  x = character(),
  levels = NULL,
  labels = levels,
  exclude = NA,
  ordered = TRUE,
  collapse = FALSE,
  verbose = FALSE,
  sep = NA
)
}
\arguments{
\item{x}{A variable to recode as an mxFactor (see \code{\link[=mxFactor]{mxFactor()}})}

\item{levels}{(default NULL). Like \code{\link[=factor]{factor()}} but UNLIKE \code{\link[=mxFactor]{mxFactor()}},
unique values will be used if levels not specified.}

\item{labels}{= levels (see \code{\link[=mxFactor]{mxFactor()}})}

\item{exclude}{= NA (see \code{\link[=mxFactor]{mxFactor()}})}

\item{ordered}{= TRUE By default return an ordered mxFactor}

\item{collapse}{= FALSE (see \code{\link[=mxFactor]{mxFactor()}})}

\item{verbose}{Whether to tell user about such things as coercing to factor}

\item{sep}{If twin data are being used, the string that separates the base from twin index
will try and ensure factor levels same across all twins.}
}
\value{
\itemize{
\item \code{\link[=mxFactor]{mxFactor()}}
}
}
\description{
A convenient version of \code{\link[=mxFactor]{mxFactor()}} supporting the common
case in which the factor levels are those in the variable.
}
\examples{
umxFactor(letters)
umxFactor(letters, verbose = TRUE) # report coercions
umxFactor(letters, ordered = FALSE) # non-ordered factor like factor(x)
# Dataframe example:
x = umx_factor(mtcars[,c("cyl", "am")], ordered = FALSE); str(x)
# =================
# = Twin example: =
# =================
data(twinData)
tmp = twinData[, c("bmi1", "bmi2")]
tmp$bmi1[tmp$bmi1 <= 22] = 22
tmp$bmi2[tmp$bmi2 <= 22] = 22
# remember to factor _before_ breaking into MZ and DZ groups
x = umxFactor(tmp, sep = ""); str(x)
xmu_check_levels_identical(x, "bmi", sep="")

# Simple example to check behavior
x = round(10 * rnorm(1000, mean = -.2))
y = round(5 * rnorm(1000))
x[x < 0] = 0; y[y < 0] = 0
jnk = umxFactor(x); str(jnk)
df  = data.frame(x = x, y = y)
jnk = umxFactor(df); str(jnk)
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umxFactanal]{umxFactanal()}}, \code{\link[=mxFactor]{mxFactor()}}
}

Other Data Functions: \code{\link{umxHetCor}()},
  \code{\link{umx_as_numeric}()},
  \code{\link{umx_cont_2_quantiles}()},
  \code{\link{umx_lower2full}()},
  \code{\link{umx_make_MR_data}()},
  \code{\link{umx_make_TwinData}()},
  \code{\link{umx_make_fake_data}()},
  \code{\link{umx_make_raw_from_cov}()},
  \code{\link{umx_polychoric}()},
  \code{\link{umx_polypairwise}()},
  \code{\link{umx_polytriowise}()},
  \code{\link{umx_read_lower}()},
  \code{\link{umx_rename}()}, \code{\link{umx_reorder}()},
  \code{\link{umx_select_valid}()},
  \code{\link{umx_stack}()}, \code{\link{umx}},
  \code{\link{xmu_data_swap_a_block}()}
}
\concept{Data Functions}
