% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxReduce}
\alias{umxReduce}
\title{Reduce models, and report the results.}
\usage{
umxReduce(model, report = c("markdown", "inline", "html"),
  baseFileName = "tmp", ...)
}
\arguments{
\item{model}{The \code{\link[=mxModel]{mxModel()}} which will be reduced.}

\item{report}{How to report the results. "html" = open in browser}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp")}

\item{...}{Other parameters to control model summary}
}
\description{
Given a \code{umx} model (currently \code{umxACE} and \code{umxGxE} are supported - ask for more!)
\code{umxReduce} will conduct a formalised reduction process. It will also report
Akaike weights are also reported showing relative support across models.

Specialized functions are called for different type of input:
\enumerate{
\item \strong{GxE model reduction} For \code{\link[=umxGxE]{umxGxE()}} models \code{\link[=umxReduceGxE]{umxReduceGxE()}} is called.
\item \strong{ACE model reduction} For \code{\link[=umxACE]{umxACE()}} models,\code{\link[=umxReduceACE]{umxReduceACE()}} is called.
}

\code{umxReduce} reports the results in a table. Set the format of the table with
\code{\link[=umx_set_table_format]{umx_set_table_format()}}, or set \code{report= "html"} to open a
table for pasting into a word processor.

\code{umxReduce} is a work in progress, with more automatic reductions coming as demand emerges.
I am thinking for RAM models to drop NS paths, and report that test.
}
\references{
\itemize{
\item Wagenmakers, E.J., & Farrell, S. (2004). AIC model selection using Akaike weights. \emph{Psychonomic Bulletin and Review}, \strong{11}, 192-196. \href{https://doi.org/10.3758/BF03206482}{doi:}
}
}
\seealso{
\code{\link[=umxReduceGxE]{umxReduceGxE()}}, \code{\link[=umxReduceACE]{umxReduceACE()}}

Other Reporting Functions: \code{\link{FishersMethod}()},
  \code{\link{loadings.MxModel}()},
  \code{\link{tmx_is.identified}()},
  \code{\link{tmx_show}()}, \code{\link{umxAPA}()},
  \code{\link{umxFactorScores}()},
  \code{\link{umxGetParameters}()},
  \code{\link{umxParameters}()},
  \code{\link{umxWeightedAIC}()},
  \code{\link{umx_APA_pval}()},
  \code{\link{umx_aggregate}()}, \code{\link{umx_names}()},
  \code{\link{umx_print}()}, \code{\link{umx_time}()},
  \code{\link{umx}}

Other Twin Reporting Functions: \code{\link{umxPlotCP}()},
  \code{\link{umxReduceACE}()},
  \code{\link{umxReduceGxE}()},
  \code{\link{umxSummarizeTwinData}()},
  \code{\link{umxSummaryACEcov}()},
  \code{\link{umxSummaryACEv}()},
  \code{\link{umxSummaryACE}()},
  \code{\link{umxSummaryCP}()},
  \code{\link{umxSummaryGxEbiv}()},
  \code{\link{umxSummaryGxE}()},
  \code{\link{umxSummaryIP}()},
  \code{\link{umxSummarySexLim}()},
  \code{\link{umxSummarySimplex}()}, \code{\link{umx}}
}
\concept{Reporting Functions}
\concept{Twin Reporting Functions}
