% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxACEcov_fixed.R
\name{umxACE_cov_fixed}
\alias{umxACE_cov_fixed}
\title{Run a Cholesky with covariates  ("fixed" / definition variables in the means style)}
\usage{
umxACE_cov_fixed(name = "ACEcov", selDVs, selCovs = NULL, dzData,
  mzData, sep = NULL, dzAr = 0.5, dzCr = 1, addStd = TRUE,
  addCI = TRUE, boundDiag = 0, weightVar = NULL,
  equateMeans = TRUE, bVector = FALSE, optimizer = NULL,
  autoRun = getOption("umx_auto_run"), tryHard = c("no", "yes",
  "mxTryHard", "mxTryHardOrdinal", "mxTryHardWideSearch"))
}
\arguments{
\item{name}{The name of the model (defaults to"ACEcov").}

\item{selDVs}{The variables to include from the data (do not include sep).}

\item{selCovs}{The covariates to include from the data (do not include sep).}

\item{dzData}{The DZ dataframe.}

\item{mzData}{The MZ dataframe.}

\item{sep}{Separator text between basename for twin variable names. Often "_T".
Used to expand selDVs into full column names, i.e., "dep" --> c("dep_T1", "dep_T2").}

\item{dzAr}{The DZ genetic correlation (defaults to .5, vary to examine assortative mating).}

\item{dzCr}{The DZ "C" correlation (defaults to 1: set to .25 to make an ADE model).}

\item{addStd}{Whether to add the algebras to compute a std model (defaults to TRUE).}

\item{addCI}{Whether to add intervals to compute CIs (defaults to TRUE).}

\item{boundDiag}{= Whether to bound the diagonal of the a, c, and e matrices.}

\item{weightVar}{(optional) Variable containing the weights to apply to data.}

\item{equateMeans}{Whether to equate the means across twins (defaults to TRUE).}

\item{bVector}{Whether to compute row-wise likelihoods (defaults to FALSE).}

\item{optimizer}{(optionally) set the optimizer. Default (NULL) does nothing.}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "mxTryHardOrdinal", "mxTryHardWideSearch"}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}} of subclass mxModel.ACEcov
}
}
\description{
Often, it is appropriate to include covariates in models.
A simple method is to regress covariates from the data using \code{\link[=lm]{lm()}}.
This is a 'fixed' effects approach.
\code{\link[=umx_residualize]{umx_residualize()}} makes this easier, even on twin data, and with complex regression formulas.
}
\details{
While these estimates are unbiased, modeling this regression in the means element of the twin model
allows correct tests for significance. Also, if DVs are not continuous, the lm-based approach
cannot be used.

For this reason, we have implemented umxACE_cov_fixed, which allows including covariates as definition variables.
The following figure shows how the ACE model with fixed covariates appears as a path diagram:

\if{html}{\figure{ACEcovOnMeans.png}{options: width="50\%" alt="Figure: ACEcovOnMeans.png"}}
\if{latex}{\figure{ACEcovOnMeans.pdf}{options: width=7cm}}

On the plus side, there is no distributional assumption for this method. A downside of this approach is that all
covariates must be non-NA, thus dropping any rows where one or more covariates are missing.
This is wasteful of data, but often cannot be avoided (though see note below).

\emph{note}: An alternative is the \code{\link[=umxACEcov]{umxACEcov()}} 'random' option. This model adds covariates to
the expected covariance matrix, thus allowing all data to be preserved.
The (BIG) downside is that this method has a strong assumption of multivariate normality.
Covariates like age, which are perfectly correlated in twins cannot be used.
Covariates like sex, which are ordinal, violate the normality assumption.
}
\examples{
\dontrun{
require(umx)
data(twinData) # ?twinData from Australian twins.
# Pick the variables
selDVs  = "ht"
selCovs = "age"
mzData <- twinData[twinData$zygosity \%in\% "MZFF", ]
dzData <- twinData[twinData$zygosity \%in\% "DZFF", ]
m1 = umxACE_cov_fixed(selDVs = selDVs, selCovs = selCovs, sep = "",
	     dzData = dzData, mzData = mzData)
m2 = umxACE(selDVs = selDVs, sep = "", dzData = dzData, mzData = mzData)
# =======================
# = lm-based equivalent =
# =======================
df_res = umx_residualize(ht ~ age, suffixes = c("1", "2"), data = twinData)
mzData = df_res[df_res$zygosity \%in\% "MZFF", ]
dzData = df_res[df_res$zygosity \%in\% "DZFF", ]
m3 = umxACE("lm_based", selDVs = selDVs, sep = "", dzData = dzData, mzData = mzData)
# ===============================
# = Example with two covariates =
# ===============================
selDVs  = "wt"
selCovs = c("age", "cohort")
twinData$cohort1 = twinData$cohort2 = as.numeric(as.factor(twinData$cohort))
mzData <- twinData[twinData$zygosity \%in\% "MZFF", ]
dzData <- twinData[twinData$zygosity \%in\% "DZFF", ]
m1 = umxACE_cov_fixed(selDVs = selDVs, selCovs = selCovs, sep = "",
	     dzData = dzData, mzData = mzData)
m1 = umxACE(selDVs = selDVs, sep = "", dzData = dzData, mzData = mzData)
}
}
\seealso{
umx_residualize umxACE

Other Twin Modeling Functions: \code{\link{power.ACE.test}()},
  \code{\link{umxACEcov}()}, \code{\link{umxACEv}()},
  \code{\link{umxACE}()}, \code{\link{umxCP}()},
  \code{\link{umxGxE_window}()}, \code{\link{umxGxEbiv}()},
  \code{\link{umxGxE}()}, \code{\link{umxIP}()},
  \code{\link{umxRotate.MxModelCP}()},
  \code{\link{umxSexLim}()}, \code{\link{umxSimplex}()},
  \code{\link{umx}}
}
\concept{Twin Modeling Functions}
