% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{FishersMethod}
\alias{FishersMethod}
\title{Fishers Method of combining p-values.}
\usage{
FishersMethod(pvalues)
}
\arguments{
\item{pvalues}{A vector of p-values, e.g. c(.041, .183)}
}
\value{
\itemize{
\item A meta-analytic p-value
}
}
\description{
\code{FishersMethod} implements R.A. Fisher's method for creating a meta-analytic p-value by combining a
set of p-values from tests of the same hypothesis in independent samples,
}
\examples{
FishersMethod(c(.041, .378))
}
\references{
\itemize{
\item Fisher, R.A. (1925). \emph{Statistical Methods for Research Workers}. Oliver and Boyd (Edinburgh). ISBN 0-05-002170-2.
Fisher, R. A (1948). "Questions and answers #14". \emph{The American Statistician}. \strong{2}: 30–31. doi:10.2307/2681650. JSTOR 2681650.
See also Stouffer's method for combining Z scores, which allow weighting.
Stouffer, S. A. and Suchman, E. A. and DeVinney, L. C. and Star, S. A. and Williams, R. M. Jr. (1949) The American Soldier, Vol. 1 - Adjustment during Army Life. Princeton, Princeton #' University Press.
}
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}()},
  \code{\link{tmx_is.identified}()},
  \code{\link{tmx_show}()}, \code{\link{umxAPA}()},
  \code{\link{umxFactorScores}()},
  \code{\link{umxGetParameters}()},
  \code{\link{umxParameters}()}, \code{\link{umxReduce}()},
  \code{\link{umxWeightedAIC}()},
  \code{\link{umx_APA_pval}()},
  \code{\link{umx_aggregate}()}, \code{\link{umx_names}()},
  \code{\link{umx_print}()}, \code{\link{umx_time}()},
  \code{\link{umx}}
}
\concept{Reporting Functions}
