% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummaryACEcov}
\alias{umxSummaryACEcov}
\alias{umxSummary.MxModelACEcov}
\title{Present results of a twin ACE-model with covariates in table and graphical forms.}
\usage{
umxSummaryACEcov(model, digits = 2, file = getOption("umx_auto_plot"),
  returnStd = FALSE, extended = FALSE, showRg = FALSE, std = TRUE,
  comparison = NULL, CIs = TRUE, zero.print = ".", report = c("1",
  "2", "html"), ...)
}
\arguments{
\item{model}{a \code{\link{umxACEcov}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{std}{= whether to show the standardized model (TRUE)}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{CIs}{Whether to show Confidence intervals if they exist (TRUE)}

\item{zero.print}{How to show zeros (".")}

\item{report}{If "html", then open an html table of the results.}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a Cholesky model with covariates, as returned by \code{\link{umxACEcov}}
}
\examples{
require(umx)
data(twinData)
selDVs = c("bmi1", "bmi2")
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
umxSummaryACE(m1)
\dontrun{
umxSummaryACE(m1, file = NA);
umxSummaryACE(m1, file = "name", std = TRUE)
stdFit = umxSummaryACE(m1, returnStd = TRUE);
}
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxACEcov}}

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEold}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCPold}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPold}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
\concept{Twin Modeling Functions}
