% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_paste_names}
\alias{umx_paste_names}
\title{umx_paste_names}
\usage{
umx_paste_names(varNames, textConstant = "", suffixes = 1:2)
}
\arguments{
\item{varNames}{a list of _base_ names, e.g c("bmi", "IQ")}

\item{textConstant}{A string separating the name and the twin suffix, e.g. "_T" (default is "")}

\item{suffixes}{a list of terminal suffixes differentiating the twins default = c("1", "2"))}
}
\value{
- vector of suffixed var names, i.e., c("a_T1", "b_T1", "a_T2", "b_T2")
}
\description{
Helper to add suffixes to names: useful for expanding base names for variables (e.g. "bmi")
into fully specified family-wise row names for variables c("bmi_T1", "bmi_T2")
Use textConstant to add a constant like "_T" after each base variable name.
This is then suffixed with e.g. "1", "2".
}
\examples{
umx_paste_names("bmi", "_T", 1:2)
umx_paste_names("bmi", suffixes = c("_T1", "_T2"))
varNames = umx_paste_names(c("N", "E", "O", "A", "C"), "_T", 1:2)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Utility Functions: \code{\link{qm}},
  \code{\link{umx_find_object}}, \code{\link{umx_grep}},
  \code{\link{umx_msg}}, \code{\link{umx_names}},
  \code{\link{umx_pb_note}}, \code{\link{umx_print}},
  \code{\link{umx_rename}}, \code{\link{umx}}
}

