% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop-search-no-location.R
\name{ukc_stop_search_no_location}
\alias{ukc_stop_search_no_location}
\title{Stop and Searches without location}
\usage{
ukc_stop_search_no_location(force, date = NULL)
}
\arguments{
\item{force}{A string containing the name of the police force to return data
for. Must be specified, and is not case sensitive.
See \code{\link[=ukc_forces]{ukc_forces()}} for details.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned. Also accepts dates in formats that can be
coerced to \code{Date} class with \code{as.Date()}.}
}
\value{
A tibble with details of stop and searches without a specific
location.
}
\description{
Returns details of stop and searches that cannot be mapped to a particular
location. Note that the police force must be specified. For all stop and
searches carried out by a police force, use \code{\link[=ukc_stop_search_force]{ukc_stop_search_force()}}.
}
\examples{
\dontrun{
ss_no_location <- ukc_stop_search_no_location(force = "city-of-london")
}

}
