% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop-search-force.R
\name{ukc_stop_search_force}
\alias{ukc_stop_search_force}
\title{Stop and Searches by Police Force}
\usage{
ukc_stop_search_force(force, date = NULL)
}
\arguments{
\item{force}{A string containing the name of the police force to return data
for. Must be specified, and is not case sensitive.
See \code{\link[=ukc_forces]{ukc_forces()}} for details.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned. Also accepts dates in formats that can be
coerced to \code{Date} class with \code{as.Date()}.}
}
\value{
A tibble with details of stop and searches by a given police force.
}
\description{
Returns details of stop and searches carried out by a particular police
force. Note that the police force must be specified.
}
\examples{
\donttest{
ss_dorset <- ukc_stop_search_force(force = "dorset")
}

}
