% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iqrOutlier.R
\name{iqrOutlier}
\alias{iqrOutlier}
\title{Identify outliers according to the IQR criterion}
\usage{
iqrOutlier(x)
}
\arguments{
\item{x}{The vector to scan for outliers.}
}
\value{
A logical vector where TRUE identifies outliers.
}
\description{
The IQR criterion holds that any value lower than one-and-a-half times the
interquartile range below the first quartile, or higher than one-and-a-half
times the interquartile range above the third quartile, is an outlier. This
function returns a logical vector that identifies those outliers.
}
\examples{

### One outlier in the miles per gallon
iqrOutlier(mtcars$mpg);

}
\seealso{
\code{\link{IQR}}
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{univariate}
