% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utest.R
\name{utest}
\alias{utest}
\title{U test}
\usage{
utest(group_id, md = NULL, data = NULL, numB = 1000)
}
\arguments{
\item{group_id}{A vector of 0s and 1s indicating to which group the samples belong. Must be in the same order as data or md.}

\item{md}{Matrix of distances between all data points.}

\item{data}{Data matrix. Each row represents an observation.}

\item{numB}{Number of resampling iterations.}
}
\value{
Returns a list with the following elements:\describe{
  \item{Bn}{Test Statistic}
  \item{Pvalue}{Replication based p-value}
  \item{Replication}{Number of replications used to compute p-value}
}
}
\description{
Test for the separation of two groups.
The null hypothesis states that the groups are homogeneous and the alternative hypothesis states that they are separate.
}
\details{
Either \code{data} or \code{md} should be provided.
If data are entered directly, Bn will be computed considering the squared Euclidean
 distance, which is compatible with \code{\link{is_homo}}, \code{\link{uclust}} and
  \code{\link{uhclust}}.

For more details see Cybis, Gabriela B., Marcio Valk, and Sílvia RC Lopes. "Clustering and classification problems in genetics through U-statistics."
Journal of Statistical Computation and Simulation 88.10 (2018)
}
\examples{

# Simulate a dataset with two separate groups, the first 5 rows have mean 0 and
# the last 5 rows have mean 5.
data <- matrix(c(rnorm(75, 0), rnorm(75, 5)), nrow = 10, byrow=TRUE)

# U test for mixed up groups
utest(group_id=c(1,0,1,0,1,0,1,0,1,0), data=data, numB=3000)
# U test for correct group definitions
utest(group_id=c(1,1,1,1,1,0,0,0,0,0), data=data, numB=3000)


}
\seealso{
\code{\link{bn}},\code{\link{is_homo}}
}
