% Generated by roxygen2 (4.0.0): do not edit by hand
\name{rnw2pdf}
\alias{rnw2pdf}
\title{Render an Rnw file into a PDF}
\usage{
rnw2pdf(file = "thesis.Rnw", biber = TRUE, saveTmpFiles = FALSE)
}
\arguments{
\item{file}{the location and name of the Rnw file to be rendered.}

\item{biber}{logical flag indicating if biber (or biblatex) backend should
be run after xelatex is called.}

\item{saveTmpFiles}{logical flag indicating if intermediary files should be
kept after PDF file is created. If \code{FALSE} the files are deleted.}
}
\value{
The name of the xelatex rendered PDF.
}
\description{
Use knitr to convert an Rnw file into xelatex (and biber)
rendered PDF.
}
\details{
This is just a sequence of system calls that runs knitr to turn the .Rnw into
a .tex, and then calls xelatex (and biber) a few more times to make sure
citations and cross-references are correct.

Temporary files (e.g. .tex's, .log's, .aux's, etc.) are stored in a temporary
(sub)directory, \code{tmp/}.
}
\examples{
\dontrun{
setwd("inst/knitr")
rnw2pdf()
}
}

