% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_pc_2D_fdtm.R
\name{pc_2D_fdtm}
\alias{pc_2D_fdtm}
\title{Create a Digital Terrain Model from UAV generated point clouds by minimum altitude sampling (fix resolution of sampling gridsize)}
\usage{
pc_2D_fdtm(
  laspcFile = NULL,
  grassVersion = 1,
  searchPath = NULL,
  gisdbasePath = NULL,
  tension = 20,
  sampleMethod = "min",
  cutExtent = NULL,
  sampleGridSize = 25,
  targetGridSize = 0.1,
  splineThresGridSize = 0.5,
  projFolder = NULL,
  proj4 = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs",
  giLinks = NULL,
  verbose = FALSE
)
}
\arguments{
\item{laspcFile}{character. default is \code{NULL} path  to the laz/las file(s)}

\item{grassVersion}{numeric. version of GRASS as derived by findGRASS() default is 1 (=oldest/only version) please note GRASS version later than 7.4 is not working with r.inlidar}

\item{searchPath}{path to look for grass}

\item{gisdbasePath}{character. default is \code{NULL} root directory of the project. NOTE the function creates two subfolder named \code{run} and \code{output}}

\item{tension}{numeric. tension of spline interpolation.}

\item{sampleMethod}{character. sampling method of r.in.lidar Statistic to use for raster values Options: n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean Default: mean}

\item{cutExtent}{clip area}

\item{sampleGridSize}{numeric, resolution extraction raster}

\item{targetGridSize}{numeric. the resolution of the target DTM raster}

\item{splineThresGridSize}{numeric. threshold of minimum gridsize tha is used for splininterpolation if the desired resolution is finer a two step approximation is choosen
first step spline interpolation using the treshold gridsize second step bilinear resampling to the desired targetGridSize.}

\item{projFolder}{subfolders that will be created/linked for R related GRASS processing}

\item{proj4}{character. valid proj4 string that should be assumingly the correct one}

\item{giLinks}{list of link2GI cli pathes, default is NULL}

\item{verbose}{to be quiet (1)}
}
\value{
raster* object
}
\description{
Create a Digital Terrain Model from a high density point cloud as typically derived by an optical UAV retrieval. Due to the poor estimation of ground points
a minimum samopling approach is applied. It retrieves on a coarse fixed sampling gridsize the minimum value and interpolates on these samples a surface grid with a higher target
resolution. this is a kind of an try and error process and provides fairly good results if the point cloud shows at least some real surface points on a not to coarse grid.
}
\examples{
\dontrun{
require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-list()
giLinks$grass<-link2GI::linkGRASS7(returnPaths = TRUE)
if (giLinks$grass$exist) {

# proj subfolders
projRootDir<-tempdir()
unlink(paste0(projRootDir,"*"), force = TRUE)
paths<-link2GI::initProj(projRootDir = projRootDir,
                         projFolders = c("data/","data/ref/","output/","run/","las/"),
                         global = TRUE,
                         path_prefix = "path_")
 
# get some colors
pal = mapview::mapviewPalette("mapviewTopoColors")

# get the data
utils::download.file(url="https://github.com/gisma/gismaData/raw/master/uavRst/data/lidar.las",
destfile=paste0("lasdata.las"))

# create 2D point cloud DTM
dtm <- pc_2D_fdtm(laspcFile = "lasdata.las",
                gisdbasePath = projRootDir,
                tension = 20 ,
                sampleGridSize = 25,
                targetGridSize = 0.5,
                giLinks = giLinks)
                
mapview::mapview(dtm)                 
                }

}
}
\author{
Chris Reudenbach
}
