% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_tvReg.R
\name{confint.tvlm}
\alias{confint.tvlm}
\alias{confint.tvar}
\alias{confint.tvsure}
\alias{confint.tvvar}
\alias{confint.tvirf}
\alias{confint.tvplm}
\title{Confidence Intervals for Objects in tvReg}
\usage{
\method{confint}{tvlm}(
  object,
  parm,
  level = 0.95,
  runs = 100,
  tboot = c("wild", "wild2"),
  ...
)

\method{confint}{tvar}(
  object,
  parm,
  level = 0.95,
  runs = 100,
  tboot = c("wild", "wild2"),
  ...
)

\method{confint}{tvsure}(
  object,
  parm,
  level = 0.95,
  runs = 100,
  tboot = c("wild", "wild2"),
  ...
)

\method{confint}{tvvar}(
  object,
  parm,
  level = 0.95,
  runs = 100,
  tboot = c("wild", "wild2"),
  ...
)

\method{confint}{tvirf}(
  object,
  parm,
  level = 0.95,
  runs = 100,
  tboot = c("wild", "wild2"),
  ...
)

\method{confint}{tvplm}(
  object,
  parm,
  level = 0.95,
  runs = 100,
  tboot = c("wild", "wild2"),
  ...
)
}
\arguments{
\item{object}{An object used to select a method.}

\item{parm}{A specification of which parameters are to be given confidence intervals, 
either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{Numeric, the confidence level required (between 0 and 1).}

\item{runs}{(optional) Number of bootstrap replications.}

\item{tboot}{Type of wild bootstrap, choices 'wild'(default), 'wild2'. Option 'wild' uses the
distribution suggested by Mammen (1993) in the wild resampling, while 'wild2' uses the standard
normal.}

\item{...}{Other parameters passed to specific methods.}
}
\value{
an object of class \code{tvsure} with BOOT, Lower and Upper different from NULL.
}
\description{
confint is used to estimate the bootstrap confidence intervals for objects with class
attribute \code{tvlm}, \code{tvar}, \code{tvirf}, \code{tvsure} and \code{tvplm}.
}
\examples{
\dontrun{
##Calculation of confidence intervals for a TVLM model

##Generation of time-varying coefficients linear model
set.seed(42)
tau <- seq(1:200)/200
beta <- data.frame(beta1 = sin(2*pi*tau), beta2= 2*tau)
X1 <- rnorm(200)
X2 <- rchisq(200, df = 4)
error <- rt(200, df = 10)
y <- apply(cbind(X1, X2)*beta, 1, sum) + error
data <- data.frame(y = y, X1 = X1, X2 = X2)

##Fitting the model and confidence interval calculation
model.tvlm <-  tvLM(y ~ 0 + X1 + X2, data = data, bw = 0.29)
tvci <- confint(model.tvlm, level = 0.95, runs = 20)

##If a second confidence interval on the "same" object is calculated, 
##for example with a different level, the calculation is faster
tvci.80 <- confint(tvci, level = 0.8)
}
}
\references{
Chen, X. B., Gao, J., Li, D., and Silvapulle, P (2017) Nonparametric estimation and 
forecasting for time-varying coefficient realized volatility models,
\emph{Journal of Business \& Economic Statistics}, online, 1-13.

Mammen, E (1993) Bootstrap and wild bootstrap for high dimensional linear models,
\emph{ Annals of Statistics}, 21, 255-285.
}
\seealso{
\code{\link{tvLM}}, \code{\link{tvAR}}, \code{\link{tvVAR}},
\code{\link{tvSURE}}
}
