% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvB.R
\name{tvBcoef}
\alias{tvBcoef}
\alias{tvBcoef.tvvar}
\title{Coefficient Array of an Estimated tvVAR}
\usage{
tvBcoef(x)

\method{tvBcoef}{tvvar}(x)
}
\arguments{
\item{x}{An object of class 'tvvar', generated by \code{\link{tvVAR}}.}
}
\value{
A list object with coefficient arrays for the lagged endogenous variables without including the intercept.
}
\description{
Returns the system estimated coefficients as an array.
}
\details{
Given an estimated time varying VAR of the form:
\deqn{\hat{{y}}_t = \hat{A}_{1t} {y}_{t-1} + \ldots + \hat{A}_{pt} {y}_{t-p} + \hat{C}_tD_t}
the function returns a list for each equation with
\eqn{(\hat{A}_{1t} | \ldots | \hat{A}_{pt} | \hat{C}_t )} set of arrays .
}
\examples{
data(Canada, package="vars")
var.2p <- vars::VAR(Canada, p = 2, type = "const")
tvvar.2p <- tvVAR(Canada, p=2, type= "const")
B <- vars::Bcoef(var.2p)
tvB <- tvBcoef(tvvar.2p)

}
