% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalize.R
\name{finalize_model}
\alias{finalize_model}
\alias{finalize_recipe}
\alias{finalize_workflow}
\title{Splice final parameters into objects}
\usage{
finalize_model(x, parameters)

finalize_recipe(x, parameters)

finalize_workflow(x, parameters)
}
\arguments{
\item{x}{A recipe, \code{parsnip} model specification, or workflow.}

\item{parameters}{A list or 1-row tibble of parameter values. Note that the
column names of the tibble should be the \code{id} fields attached to \code{tune()}.
For example, in the \code{Examples} section below, the model has \code{tune("K")}. In
this case, the parameter tibble should be "K" and not "neighbors".}
}
\value{
An updated version of \code{x}.
}
\description{
The \verb{finalize_*} functions take a list or tibble of tuning parameter values and
update objects with those values.
}
\examples{
\donttest{
data("example_ames_knn")

library(parsnip)
knn_model <-
  nearest_neighbor(
    mode = "regression",
    neighbors = tune("K"),
    weight_func = tune(),
    dist_power = tune()
  ) \%>\%
  set_engine("kknn")

lowest_rmse <- select_best(ames_grid_search, metric = "rmse")
lowest_rmse

knn_model
finalize_model(knn_model, lowest_rmse)
}
}
