% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_ses.R
\name{ts_fil_ses}
\alias{ts_fil_ses}
\title{Simple Exponential Smoothing}
\usage{
ts_fil_ses(gamma = FALSE)
}
\arguments{
\item{gamma}{If TRUE, enables the gamma seasonality component.}
}
\value{
a \code{ts_fil_ses} obj.
}
\description{
This code implements simple exponential smoothing on a time series.
Simple exponential smoothing is a smoothing technique that can include or exclude
trend and seasonality components in time series forecasting, depending on the specified parameters.
}
\examples{
# time series with noise
library(daltoolbox)
data(sin_data)
sin_data$y[9] <- 2*sin_data$y[9]

# filter
filter <- ts_fil_ses()
filter <- fit(filter, sin_data$y)
y <- transform(filter, sin_data$y)

# plot
plot_ts_pred(y=sin_data$y, yadj=y)
}
