\name{run_solver}
\alias{run_solver}
\title{Runs a solver on a TSP instance.}
\usage{
  run_solver(x, method, ...)
}
\arguments{
  \item{x}{[\code{\link{tsp_instance}}]\cr TSP instance.}

  \item{method}{[\code{character(1)}]\cr Solver to use on
  TSP instance. To use concorde and/or linkern it is
  necessary to specify the path to the concorde/linkern
  executable with \code{\link[TSP]{concorde_path}}.}

  \item{...}{[any]\cr Control parameters for solver.}
}
\value{
  [\code{\link[TSP]{TOUR}}] TOUR object from package TSP,
  containing order of cities, tour length and method name
  that generated this solution.
}
\description{
  Currently the following solvers are supported:
  nearest_insertion: See \code{\link[TSP]{solve_TSP}}.
  farthest_insertion : See \code{\link[TSP]{solve_TSP}}.
  cheapest_insertion : See \code{\link[TSP]{solve_TSP}}.
  arbitrary_insertion: See \code{\link[TSP]{solve_TSP}}.
  nn: See \code{\link[TSP]{solve_TSP}}.  repetitive_nn: See
  \code{\link[TSP]{solve_TSP}}.  concorde: See
  \code{\link[TSP]{solve_TSP}}.
}
\examples{
x = random_instance(10)
tours = sapply(c("nn", "cheapest_insertion", "arbitrary_insertion"), function(solver) {
  list(solver = run_solver(x, method = solver))
})
\dontrun{
  concorde_path(path = "/absolute/path/to/concorde/executable")
  concorde_tour = run_solver(x, method = "concorde")
  concorde_tour = run_solver(x, method = "linkern")
}
}

