% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{has_gaps}
\alias{has_gaps}
\title{Does a tsibble have implicit gaps in time?}
\usage{
has_gaps(.data, .full = FALSE, .name = ".gaps")
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{.full}{\code{FALSE} to find gaps for each series within its own period.
\code{TRUE} to find gaps over the entire time span of the data.}

\item{.name}{Strings to name new columns.}
}
\value{
A tibble contains "key" variables and new column \code{.gaps} of \code{TRUE}/\code{FALSE}.
}
\description{
Does a tsibble have implicit gaps in time?
}
\examples{
harvest <- tsibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2013),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = fruit, index = year
)
has_gaps(harvest)
has_gaps(harvest, .full = TRUE)
}
\seealso{
Other implicit gaps handling: \code{\link{count_gaps}},
  \code{\link{fill_gaps}}, \code{\link{scan_gaps}}
}
\concept{implicit gaps handling}
