% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{fill_gaps}
\alias{fill_gaps}
\alias{fill_gaps.tbl_ts}
\title{Turn implicit missing values into explicit missing values}
\usage{
fill_gaps(.data, ...)

\method{fill_gaps}{tbl_ts}(.data, ..., .full = FALSE)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{A set of name-value pairs. The values provided will only replace
missing values that were marked as "implicit", and will leave previously
existing \code{NA} untouched.
\itemize{
\item empty: filled with default \code{NA}.
\item filled by values or functions.
}}

\item{.full}{\code{FALSE} to insert \code{NA} for each key within its own period. \code{TRUE}
to fill \code{NA} over the entire time span of the data (a.k.a. fully balanced panel).}
}
\description{
Turn implicit missing values into explicit missing values
}
\examples{
harvest <- tsibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2014),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = id(fruit), index = year
)

# gaps as default `NA` ----
fill_gaps(harvest, .full = TRUE)
full_harvest <- fill_gaps(harvest, .full = FALSE)
full_harvest

# use fill() to fill `NA` by previous/next entry
full_harvest \%>\% 
  group_by(fruit) \%>\% 
  fill(kilo, .direction = "down")

# replace gaps with a specific value ----
harvest \%>\%
  fill_gaps(kilo = 0L)

# replace gaps using a function by variable ----
harvest \%>\%
  fill_gaps(kilo = sum(kilo))

# replace gaps using a function for each group ----
harvest \%>\%
  group_by(fruit) \%>\%
  fill_gaps(kilo = sum(kilo))

# leaves existing `NA` untouched ----
harvest[2, 3] <- NA
harvest \%>\%
  group_by(fruit) \%>\%
  fill_gaps(kilo = sum(kilo, na.rm = TRUE))

# replace NA ----
pedestrian \%>\%
  group_by(Sensor) \%>\%
  fill_gaps(Count = as.integer(median(Count)))
}
\seealso{
\link[tidyr:fill]{tidyr::fill}, \link[tidyr:replace_na]{tidyr::replace_na} for handling missing values \code{NA}.

Other implicit gaps handling: \code{\link{count_gaps}},
  \code{\link{has_gaps}}, \code{\link{scan_gaps}}
}
\concept{implicit gaps handling}
