% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{stretch}
\alias{stretch}
\alias{stretch_lst}
\alias{stretch_dfr}
\alias{stretcher}
\title{Stretching window calculation}
\usage{
stretch(x, .f, ..., size = 1, init = 1)

stretch_lst(x, .f, ..., size = 1, init = 1)

stretch_dfr(x, .f, ..., size = 1, init = 1, .id = NULL)

stretcher(x, size = 1, init = 1)
}
\arguments{
\item{x}{A vector of numerics, or data frame. If a data frame, row-wise rolling
window is performed.}

\item{.f}{A function or one-sided formula using purrr-like syntax. If a
formula, it is converted to a function.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{size, init}{An integer for moving and initial window size.}

\item{.id}{If not \code{NULL} a variable with this name will be created giving
either the name or the index of the data frame, which is passed to
\link[dplyr:bind_rows]{dplyr::bind_rows}.}
}
\description{
Fixing an initial window and expanding more observations:
\itemize{
\item \code{stretch()} always returns a vector of numerics
\item \code{stretch_lst()} returns a list
\item \code{stretch_dfr()} return data frame using row-binding
\item \code{stretcher()} splits the input \code{x} to a list according to the window size.
}
}
\examples{
x <- 1:10
stretch(x, mean, init = 3)
stretch(x, ~ mean(.), init = 3)
stretcher(x, init = 3)

# stretching a 2-day window for a data frame ----
sx <- pedestrian \%>\% 
  filter(Sensor == "Southern Cross Station", Date <= as.Date("2015-01-10"))
sx \%>\%
  stretch_dfr(~ quantile(.$Count), init = 48)
}
\seealso{
\link{slide} for sliding window with overlapping observations;
\link{tile} for tiling window without overlapping observations.
}
