% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{predict.knnForecast}
\alias{predict.knnForecast}
\title{Predict method for KNN models for time series forecasting.}
\usage{
\method{predict}{knnForecast}(object, h, ...)
}
\arguments{
\item{object}{a \code{knnForecast} object obtained by a call to the
\code{\link{knn_forecasting}} function.}

\item{h}{an integer. The forecasting horizon.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a \code{knnForecast} object with the prediction and information
about the KNN model, see the documentation of \code{\link{knn_forecasting}}
for the structure of \code{knnForecast} objects.
}
\description{
Predicted values based on a KNN model for time series forecasting.
}
\details{
If the models uses the MIMO strategy for multiple-step ahead prediction,
the forecasting horizon is fixed to the model forecasting horizon.
}
\examples{
pred <- knn_forecasting(UKgas, h = 4, k = 1, msas = "recursive")
new_pred <- predict(pred, h = 6)
print(new_pred$prediction)
plot(new_pred) # To see a plot with the forecast

}
