% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdqr.R
\name{dghyp}
\alias{dghyp}
\alias{pghyp}
\alias{qghyp}
\alias{rghyp}
\title{Generalized Hyperbolic Distribution (alpha-beta-delta-mu parameterization)}
\usage{
dghyp(x, alpha = 1, beta = 0, delta = 1, mu = 0, lambda = 1, log = FALSE)

pghyp(
  q,
  alpha = 1,
  beta = 0,
  delta = 1,
  mu = 0,
  lambda = 1,
  lower_tail = TRUE,
  log = FALSE
)

qghyp(
  p,
  alpha = 1,
  beta = 0,
  delta = 1,
  mu = 0,
  lambda = 1,
  lower_tail = TRUE,
  log = FALSE
)

rghyp(n, alpha = 1, beta = 0, delta = 1, mu = 0, lambda = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha}{tail parameter.}

\item{beta}{skewness parameter.}

\item{delta}{scale parameter.}

\item{mu}{location parameter.}

\item{lambda}{additional shape parameter determining subfamilies of this
distributions.}

\item{log}{(logical) if TRUE, probabilities p are given as log(p).}

\item{lower_tail}{if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
d gives the density, p gives the distribution function, q gives the quantile function
and r generates random deviates. Output depends on x or q length, or n for the random number
generator.
}
\description{
Density, distribution, quantile function and random number
generation for the generalized hyperbolic distribution
using the alpha-beta-delta-mu-lambda parameterization.
}
