% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{tsprofile.tsdistribution.spec}
\alias{tsprofile.tsdistribution.spec}
\alias{tsprofile}
\title{Model Parameter Profiling}
\usage{
\method{tsprofile}{tsdistribution.spec}(
  object,
  nsim = 100,
  sizes = c(800, 1000, 1500, 2000, 3000),
  seed = NULL,
  trace = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsdistribution.spec} with pre-set parameters.}

\item{nsim}{the number of paths to generate.}

\item{sizes}{a vector of data sizes for which to simulate and estimate.}

\item{seed}{an object specifying if and how the random number generator
should be initialized. See the simulate documentation for more details.}

\item{trace}{whether to show the progress bar. The user is expected to have
set up appropriate handlers for this using the \dQuote{progressr} package.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tsdistribution.profile}.
}
\description{
Profiles the model parameters under the specified distribution.
}
\details{
The function profiles the parameters of a model by simulating and
then estimating multiple paths from the assumed distribution. This makes it possible
to obtain a better understanding of the convergence properties (RMSE) of each
parameter under different data sizes.
}
\note{
The function can use parallel functionality as long as the user has set
up a \code{\link[future]{plan}} using the future package.
}
