% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acv_arma.R
\name{acv_arma}
\alias{acv_arma}
\title{Compute a theoretical autocovariance function of ARMA process}
\usage{
acv_arma(phi, theta, n)
}
\arguments{
\item{phi}{vector containing the AR parameters}

\item{theta}{vector containing the MA parameters}

\item{n}{length of the time series}
}
\value{
vector of length n containing the autocovariances
}
\description{
Function \code{acv_arma} computes a theoretical autocovariance function of ARMA process.
}
\examples{

## Example from Brockwell & Davis (1991, page 92-94)
## also in help page of ARMAacf (from stats)
n <- 0:9
answer <- 2^(-n) * (32/3 + 8 * n) /(32/3)
acv <- acv_arma(c(1.0, -0.25), 1.0, 10)
all.equal(acv/acv[1], answer)

}
\seealso{
\code{\link{dacv_arma}}.
}

