% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.TVAR.R, R/predict.VAR.R
\name{predict.TVAR}
\alias{predict.TVAR}
\alias{predict.VAR}
\alias{predict.VECM}
\title{Predict method for objects of class \sQuote{\code{VAR}}, \sQuote{\code{VECM}} or \sQuote{\code{TVAR}}}
\usage{
\method{predict}{TVAR}(object, newdata, n.ahead = 5, newdataTrendStart, ...)

\method{predict}{VAR}(object, newdata, n.ahead = 5, newdataTrendStart,
  exoPred = NULL, ...)
}
\arguments{
\item{object}{An object of class  \sQuote{\code{VAR}}, \sQuote{\code{VECM}} or \sQuote{\code{TVAR}}}

\item{newdata}{Optional. A new data frame to predict from. 
This should contain lags of the level of the original series. See Details.}

\item{n.ahead}{An integer specifying the number of forecast steps.}

\item{newdataTrendStart}{If \sQuote{\code{newdata}} is provided by the user, 
and the estimated model includes a trend, 
this argument specifies where the trend should start}

\item{\dots}{Arguments passed to the unexported \sQuote{\code{VAR.gen}} or \sQuote{\code{TVAR.gen}} function}

\item{exoPred}{vector/matrix of predictions for the exogeneous variable(s) (with \sQuote{\code{n.ahead}} rows).
Only for \sQuote{\code{VAR}}/\sQuote{\code{VECM}}, not for \sQuote{\code{TVAR}}.}
}
\value{
A matrix of predicted values.
}
\description{
Forecating the \strong{level} of a series estimated by  \sQuote{\code{VAR}} / \sQuote{\code{VECM}} or \sQuote{\code{TVAR}}
}
\details{
The forecasts are obtained recursively, and are for the levels of the series.  

When providing newdata, newdata has to be ordered chronologically, 
so that the first row/element is the earliest value. 

For VECM, the forecasts are obtained by transforming the VECM to a VAR (using function \code{\link{VARrep}}). 
Note that a VECM(lag=p) corresponds to a VAR(lag=p+1), so that if the user provides newdata 
for a VECM(lag=p), newdata should actually contain p+1 rows.
}
\examples{

data(barry)
barry_in <- head(barry, -5)
barry_out <- tail(barry, 5)

mod_vecm <- VECM(barry_in, lag=2)
mod_var <- lineVar(barry_in, lag=3)
mod_tvar <- TVAR(barry_in, lag=3, nthresh=1, thDelay=1)

pred_vecm <- predict(mod_vecm)
pred_var  <- predict(mod_var) 
pred_tvar <- predict(mod_tvar)

 
## compare forecasts on a plot
n <- 30
plot(1:n, tail(barry[,1], n), type="l", xlim=c(0,n))
lines((n-5+1):n, pred_var[,1], lty=2, col=2)
lines((n-5+1):n, pred_vecm[,1], lty=2, col=3)
lines((n-5+1):n, pred_tvar[,1], lty=2, col=4) 
legend("bottomright", lty=c(1,2,2,2), col=1:4, legend=c("true", "var", "vecm", "tvar"))

## example for newdata:
all.equal(predict(mod_vecm), predict(mod_vecm, newdata=barry[c(317, 318, 319),]))
}
\seealso{
\code{\link{lineVar}} and \code{\link{VECM}}. \code{\link{VARrep}}

A more sophisticated predict function, allowing to do sub-sample rolling
predictions: \code{\link{predict_rolling}}.
}
\author{
Matthieu Stigler
}
\keyword{regression}
