% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{truth_trajectory_data}
\alias{truth_trajectory_data}
\alias{sessions}
\alias{phases}
\alias{cjudgments}
\alias{ratings}
\title{Data from the Longitudinal Illusory Truth Study}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 631 rows and 17 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 2282 rows and 8 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 39406 rows and 3 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 72215 rows and 4 columns.
}
\usage{
sessions

phases

cjudgments

ratings
}
\description{
A collection of four data frames representing the anonymized
longitudinal data in tidy format from
\insertCite{Henderson_Simons_Barr_2021;textual}{truthiness}.
}
\details{
Each data frame contains a subset of the following variables:

\describe{
  \item{\code{ID}}{Participant identifier.}

  \item{\code{list_id}}{Stimulus list identifier.}

  \item{\code{phase_id}}{Phase number (1-4).}

  \item{\code{stim_id}}{Stimulus identifier.}

  \item{\code{Age}}{Age of participant in years.}

  \item{\code{Gender}}{Gender of participant.}

  \item{\code{Nationality}}{Nationality of participant.}

  \item{\code{NativeLang}}{Native language of participant.}

  \item{\code{duration_secs}}{Duration of the phase in seconds.}

  \item{\code{category}}{Category the participant selected for this statement.}

  \item{\code{trating}}{Truth rating on a seven-point scale, 1=Definitely
  False, 7=Definitely True.}

  \item{\code{excl_phase}}{Phase in which participant was excluded (\code{NA}
  if never excluded).}

  \item{\code{excl_reason}}{Reason for participant exclusion.}

  \item{\code{p_excl_reason}}{Reason for phase exclusion.}

  \item{\code{chk_anydata}}{Whether there is ratings data for at least one
  phase for this participant after phase-level exclusions.}

  \item{\code{chk_consent_all}}{Whether participant gave consent for all
  phases.}

  \item{\code{chk_consent}}{Whether participant gave consent for this phase.}

  \item{\code{chk_dur_all}}{Whether all phase durations for this
  participant were within an acceptable range.}

  \item{\code{chk_finished}}{Whether participant completed the rating task
  for this phase.}

  \item{\code{chk_native}}{Whether participant is a native speaker of
  English.}

  \item{\code{chk_nocheat}}{Whether participant never looked up answers.}

  \item{\code{chk_noduplicates}}{Whether there were no duplicated
  sessions.}

  \item{\code{chk_noflatline}}{Whether the participant did not produce
  'flatline' responses.}

  \item{\code{chk_notmanex}}{Whether the participant (or phase) is not
  manually excluded.}

  \item{\code{keep}}{Logical value, whether to keep (TRUE) or exclude
  (FALSE) participant (or phase data); this is a boolean "and" of
  all of the exclusion criteria (\code{chk_*} variables) for that participant (or
  phase).}
}

The \code{sessions} data frame contains information about the 631
participants who were recruited to the study. The \code{chk_*}
variables are logical variables representing exclusion
criteria. The variable \code{keep} is a boolean "AND" of these
criteria, and thus has a value of \code{TRUE} for participants who
are to be included and \code{FALSE} for those who are to be
excluded.

The \code{phases} data frame contains data from the 2,282 phases
that were initiated by participants. Each participant who was not
excluded during data collection had the opportunity to complete up
to four phases of data collection taking place (1) immediately
after the exposure phase; (2) one day after exposure; (3) one week
after exposure; and (4) one month after exposure. The \code{chk_*}
variables in this data frame represent exclusion criteria, and
\code{keep} is a boolean "AND" of those criteria along with the
\code{keep} variable from the \code{sessions} table. In other
words, to apply the full set of participant-level and phase-level
exclusion criteria for the study, simply include those rows in
\code{phases} where \code{keep} is set to \code{TRUE}, and join
this table to the others in the set; see the example below.

The \code{cjudgments} table contains 39,406 category judgments that
were produced in the exposure phase (phase 1) of the study.

The \code{ratings} data frame contains 72,215 truth ratings of the
stimulus statements used in the study. Ratings were on a 1-7 scale
(1 = definitely false; 7 = definitely true).
}
\examples{
library(dplyr)

## apply exclusions and merge with ratings data
ratings_incl <- phases \%>\%
  filter(keep) \%>\%                                        # apply exclusions
  inner_join(sessions \%>\% select(ID, list_id), "ID") \%>\%  # get list ID
  inner_join(ratings, c("ID", "phase_id"))

## look up conditions and calculate cell means
ratings_incl \%>\%
  inner_join(stimulus_conditions, c("list_id", "stim_id")) \%>\% # lookup condition
  group_by(repetition, interval) \%>\%
  summarize(rating_mean = mean(trating),
            rating_sd = sd(trating),
            N = n()) \%>\%
  ungroup()
}
\references{
\insertAllCited{}
}
\keyword{datasets}
