% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{equivtest}
\alias{equivtest}
\title{Run Equivalence Tests on Existing CLMM Object}
\usage{
equivtest(mod, .data, main_effect = FALSE, delta = 0.14)
}
\arguments{
\item{mod}{Fitted model object, result of call to \code{clmm}.}

\item{.data}{Data frame containing source data.}

\item{main_effect}{Whether to perform the test for the main effect (TRUE) or interaction (FALSE).}

\item{delta}{Delta (SESOI) for the equivalence test, in raw log odds units.}
}
\value{
A vector with p-values from the equivalence test(s);
  elements named \code{simple} test simple effects, while elements
  named \code{equiv} contain the corresponding equivalence test
  results.
}
\description{
Run Equivalence Tests on Existing CLMM Object
}
\examples{
moddata <- get_model_data()

equivtest(truth_trajectory_models[["main2"]], moddata,
          main_effect = TRUE)

}
