% Generated by roxygen2 (4.0.2): do not edit by hand
\name{logit}
\alias{inv.logit}
\alias{log_inv.logit}
\alias{logit}
\title{Logit (log odds) of a probability}
\usage{
logit(p)

inv.logit(x)

log_inv.logit(x)
}
\arguments{
\item{p}{a scalar, vector or matrix, where all elements are between 0 and 1}

\item{x}{a scalar, vector or matrix}
}
\value{
\describe{
\item{logit}{result = log(p/(1-p))}
\item{inv.logit}{result = exp(x) / (1+exp(x))}
\item{log_inv.logit}{result = x - log1p(exp(x))}
}
}
\description{
Returns the logit, inverse logit, or log inverse logit of x.
}
\details{
log_inv.logit is a (often) numerically stable alternative
to log(inv.logit(x)).  It should be less sensitive to overflow and
underflow with very large or very small x.
}
\keyword{internal}

