% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_basedata.R
\name{get_basedata}
\alias{get_basedata}
\title{Function to retrieve customized U.S. basing data}
\usage{
get_basedata(host = NA, country_count = FALSE)
}
\arguments{
\item{host}{The Correlates of War (COW) numeric country code or ISO3C code for the host country or countries in the series}

\item{country_count}{Logical. Should the function return a country-level count of the total number of bases or the country-site data}
}
\value{
\code{get_basedata()} returns a data frame containing information on U.S. military bases present within selected host countries. This can be customized to include country-base observations or country-count observations.
}
\description{
\code{get_basedata()} generates a customized data frame containing data obtained from David Vine's U.S. basing data.
}
\details{
Our research team updated these data through 2018.
}
\examples{

\dontrun{
library(tidyverse)
library(troopdata)

example <- get_basedata(host = NA)

head(example)

}

}
\references{
David Vine. 2015. Base Nation. Metropolitan Books. New York, NY.
}
\author{
Michael E. Flynn
}
