% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling.R, R/triptych_murphy.R,
%   R/triptych_reliability.R, R/triptych_roc.R
\name{resampling_cases}
\alias{resampling_cases}
\alias{resampling_cases.triptych_murphy}
\alias{resampling_cases.triptych_reliability}
\alias{resampling_cases.triptych_roc}
\title{Bootstrap case resampling for triptych objects}
\usage{
resampling_cases(x, level = 0.9, n_boot = 1000, ...)

\method{resampling_cases}{triptych_murphy}(x, level = 0.9, n_boot = 1000, ...)

\method{resampling_cases}{triptych_reliability}(x, level = 0.9, n_boot = 1000, ...)

\method{resampling_cases}{triptych_roc}(x, level = 0.9, n_boot = 1000, ...)
}
\arguments{
\item{x}{One of the triptych objects.}

\item{level}{A single value that determines which quantiles of
the bootstrap sample to return. These quantiles envelop \code{level * n_boot}
bootstrap draws.}

\item{n_boot}{The number of bootstrap samples.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A list of tibbles that contain the information to draw confidence regions.
The length is equal to the number of forecasting methods in \code{x}.
}
\description{
This function is intended to be called from \code{\link[=add_confidence]{add_confidence()}},
by specifying \code{"resampling_cases"} in the \code{method} argument.
}
\details{
Case resampling assumes independent and identically distributed forecast-observation pairs.
A given number of bootstrap samples are the basis for pointwise computed confidence intervals.
For every bootstrap sample, we draw forecast-observations pairs with replacement until the size of the original data set is reached.
}
\examples{
data(ex_binary, package = "triptych")

# Bootstrap resampling is expensive
# (the number of bootstrap samples is small to keep execution times short)

tr <- triptych(ex_binary) |>
  dplyr::slice(1, 9) |>
  add_confidence(level = 0.9, method = "resampling_cases", n_boot = 20)

}
