% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_sPwRnaiveBonf.R
\name{sPwRnaiveBonf}
\alias{sPwRnaiveBonf}
\title{Power of testing the secondary hypothesis using Bonferroni}
\usage{
sPwRnaiveBonf(
  alpha,
  alpha0 = alpha/2,
  t1,
  delta1,
  iuse1,
  phi1 = rep(1, length(alpha))
)
}
\arguments{
\item{alpha}{a number shows the overall error rate}

\item{alpha0}{a number shows the error rate assigned to the primary endpoint initially}

\item{t1}{a vector shows the information times of the secondary endpoint}

\item{delta1}{a value of delta for hypothesis H1}

\item{iuse1}{an integer shows the type of group sequential boundaries used for the secondary endpoint}

\item{phi1}{a parameter for the power family or the HSD gamma family for the secondary endpoint}
}
\value{
a value of the probability that H1 is rejected, the power, using the naive Bonferroni method
}
\description{
This function computes the power of testing the secondary hypothesis using Bonferroni
}
\examples{
alpha <-  0.025
alpha0 <- 0.01
iuse0 <- 4
iuse1 <- 4
phi0 <- -4
phi1 <- -4
tc0 <- c(3,6,9,12,18)
tc1 <- c(6,12,18,36)
t0 <- (1:5)/5
t1 <- (1:4)/4
rho <- 0.5
delta0 <- 1
delta1 <- 3
sPwRnaiveBonf(alpha=alpha, 
    alpha0=alpha0, 
    t1=t1, 
    delta1=delta1, 
    iuse1=iuse1, 
    phi1=phi1)
}
